#!/bin/sh
#********************************************************************
#*                 Omnidex Utilities uninstall script.
#*    (C) COPYRIGHT DYNAMIC INFORMATION SYSTEMS CORPORATION
#*              -----   ALL RIGHTS RESERVED  -----
#*    The use, duplication, or distribution of this software without
#*    the express written consent of Dynamic Information Systems Corp.
#*    is prohibited.
#********************************************************************
#
   set -e
#
# get system date
#
   SYS_ADAY=`date | cut -d" " -f1`
   SYS_MNTH=`date | cut -d" " -f2`
   SYS_NDAY=`date | cut -d" " -f3`
#
# The numeric day may be a single digit.
#
   if [ -z $SYS_NDAY ]; then
      SYS_NDAY=`date | cut -d" " -f4`
      SYS_YEAR=`date | cut -d" " -f7`
   else
      SYS_YEAR=`date | cut -d" " -f6`
   fi
   SYS_DATE="$SYS_ADAY $SYS_MNTH $SYS_NDAY $SYS_YEAR"
#
#  get system type
#
   SYS_TYPE=`uname -s`
   case $SYS_TYPE in
      AIX)       SYS_VERS=`uname -v`"."`uname -r`;;
      SunOS)     SYS_VERS=`uname -r | cut -c1-3`;;
      HP-UX)     SYS_VERS=`uname -r | cut -c3-4`;;
      OSF1)      SYS_VERS=`uname -r | cut -c2-4`;;
      DYNIX/ptx) SYS_VERS=`uname -v`;SYS_VERS=${SYS_VERS#V};SYS_VERS=${SYS_VERS%.*};;
      Linux)     SYS_VERS=`uname -r | cut -c1-3`;;
      *)         SYS_VERS=" ";;
   esac
#
# header
#
   echo ""
   echo "Omnidex Installer for $SYS_TYPE($SYS_VERS)                 $SYS_DATE"
   echo "(c)Dynamic Information Systems Corporation             1985-$SYS_YEAR"
   echo ""
   echo "Welcome to DISC's Omnidex software installation system.  If "
   echo "you have any problems with this utility please contact our Technical "
   echo "Support staff at:"
   echo ""
   echo "  Phone:      303-444-6610"
   echo "  Email:      support@disc.com"
   echo "  Internet:   http://www.omnidex.com"
   echo ""
   echo "Thank you for using Omnidex."
   echo ""
   echo "This utility uninstalls Omnidex software from /opt/omnidex directory."
   echo "It removes the omnidex symbolic links in /usr/bin and omnidex.conf"
   echo " file in /etc/ld.so.conf.d"
   echo ""
   echo ""
   echo "Available responses to prompts are in parentheses () and default"
   echo "responses are in square brackets []."
   echo ""
#
   while true; do
      read -p "Do you wish to continue (Y/[N])? " reply
      case ${reply:=N} in
         [Yy]* ) break;;
         [Nn]* ) echo ""; exit;;
      esac
   done
#
   remove_all=false
   while true; do
      read -p "Do you want to remove the log and dump files ([Y]/N)? " reply
      case ${reply:=Y} in
         [Yy]* ) remove_all=true; break;;
         [Nn]* ) break;;
      esac
   done
#
   echo ""
   echo "Stopping omnidex service (if running)"
   service omnidexd stop > /dev/null
#
   echo ""
   echo "Unregistering omnidex license"
   odxsql -cmd='unregister license with type=uninstall' -exit -nobanner > /dev/null 2>&1
#
   echo ""
   echo "Removing omnidexd in /etc/init.d"
   rm -f /etc/init.d/omnidexd
#
   echo ""
   echo "Removing omnidex.conf in /etc/ld.so.conf.d"
   rm -f /etc/ld.so.conf.d/omnidex.conf
   ldconfig
#
   echo "Removing symbolic links in /usr/bin"
   rm -f /usr/bin/odxsql
   rm -f /usr/bin/odxnet
   rm -f /usr/bin/omnidex
   rm -f /usr/bin/odxversions
#
   echo "Removing files in /opt/omnidex directory..."
   if $remove_all; then
      rm -rf /opt/omnidex
   else
      rm -rf /opt/omnidex/bin
      rm -rf /opt/omnidex/include
      rm -rf /opt/omnidex/src
      rm -rf /opt/omnidex/config
      rm -rf /opt/omnidex/lib
      rm -f  /opt/omnidex/odxuninstall
   fi
#
   echo ""
   echo "Omnidex has been uninstalled successfully."
   echo ""
#
#********************************************************************
#***       End of the Omnidex install utility script.
#********************************************************************

