/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJNative;
import omnidex.client.OdxCLJTrace;

public class OdxCLJStatus {
    public static final int JDBC_MAJOR_VERSION = 1;
    public static final int JDBC_MINOR_VERSION = 3;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_WARN = 1;
    public static final int STATUS_INFO = 2;
    public static final int STATUS_BUFFLEN = 3;
    public static final int STATUS_COUNT = 4;
    public static final int STATUS_PID = 6;
    public static final int STATUS_TID = 7;
    public static final int STATUS_TRANSACTION = 8;
    public static final int STATUS_INSTANCE = 9;
    public static final int STATUS_CURSOR = 10;
    public static final int STATUS_CPU = 11;
    public static final int STATUS_ELAPSED = 12;
    public static final int STATUS_SAVE_CURSOR = 13;
    public static final int STATUS_DATA_1 = 14;
    public static final int STATUS_COLUMN_COUNT = 15;
    public static final int STATUS_STATEMENT_ID = 16;
    public static final int STATUS_DATA_4 = 17;
    public static final int STATUS_DATA_5 = 18;
    public static final int STATUS_UPDATE_FLAG = 19;
    public static final int STATUS_PARENT_COUNT = 46;
    public static final int STATUS_PREINTERSECT_COUNT = 48;
    private long m_instance;
    private int[] m_oaStatus = OdxCLJNative.createStatus();
    private int m_endian;
    private boolean m_readOnly;
    private int m_updateCursor;
    private String m_oaVersion;
    private String m_environmentName;
    private String m_environmentFile;
    private byte[] m_databaseInfo;
    private String m_timezone;

    protected OdxCLJStatus() {
        this.m_instance = OdxCLJNative.createInstance();
    }

    private void setStatus(int[] nArray) {
        this.m_oaStatus = nArray;
    }

    private long intsToLong(int n) {
        return (long)this.m_oaStatus[n + 1] << 32 | (long)this.m_oaStatus[n] & 0xFFFFFFFL;
    }

    protected int[] getStatus() {
        return this.m_oaStatus;
    }

    protected int getErrorCode() {
        return this.m_oaStatus[0];
    }

    protected long getStatusCount() {
        return this.intsToLong(4);
    }

    public int getStatusBufferLength() {
        return this.m_oaStatus[3];
    }

    protected int getStatusCursor() {
        return this.m_oaStatus[10];
    }

    protected int getStatusCPUTime() {
        return this.m_oaStatus[11];
    }

    protected int getStatusElapsedTime() {
        return this.m_oaStatus[12];
    }

    protected long getStatusParentCount() {
        return this.intsToLong(46);
    }

    protected long getStatusPreIntersectCount() {
        return this.intsToLong(48);
    }

    protected int getStatusColumnCount() {
        return this.m_oaStatus[15];
    }

    protected int getStatusStatementId() {
        return this.m_oaStatus[16];
    }

    protected int getStatusUpdateFlag() {
        return this.m_oaStatus[19];
    }

    protected String getTimezone() {
        return this.m_timezone;
    }

    public static String getDriverVersion() {
        return new String(OdxCLJNative.getOaVersion(0L));
    }

    public static int getDriverMajorVersion() {
        String string = new String(OdxCLJNative.getOaVersion(0L));
        int n = string.indexOf(46);
        return n == -1 ? 0 : Integer.parseInt(string.substring(0, n));
    }

    public static int getDriverMinorVersion() {
        int n;
        int n2 = 0;
        String string = new String(OdxCLJNative.getOaVersion(0L));
        int n3 = string.indexOf(46);
        if (n3 != -1 && (n = string.indexOf(46, n3 + 1)) != -1) {
            n2 = Integer.parseInt(string.substring(n3 + 1, n));
        }
        return n2;
    }

    private int replaceStatusCursor(int n) {
        int n2 = this.m_oaStatus[13];
        this.m_oaStatus[13] = n;
        return n2;
    }

    protected int getEndian() {
        return this.m_endian;
    }

    protected boolean getReadOnly() {
        return this.m_readOnly;
    }

    protected String getErrorMessage() {
        return new String(OdxCLJNative.getErrorMessage(this.m_oaStatus));
    }

    protected static String getErrorMessage(int n) {
        return new String(OdxCLJNative.getStaticErrorMessage(n));
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected static String makeOptionString(Properties properties) {
        if (properties == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("user") || string2.equalsIgnoreCase("password") || string2.startsWith(":") || (string = properties.getProperty(string2)) == null) continue;
            if (string2.equalsIgnoreCase("HOSTOACONNECTOPTIONS")) {
                stringBuffer.append(" ").append(string);
                continue;
            }
            stringBuffer.append(" ").append(string2).append("='").append(string).append("'");
        }
        return stringBuffer.length() != 0 ? stringBuffer.toString() : "";
    }

    protected void connect(String string, Properties properties) throws SQLException {
        String string2;
        String string3;
        this.trace("connect");
        if (properties != null) {
            string3 = properties.getProperty("user");
            string2 = properties.getProperty("password");
        } else {
            string3 = "";
            string2 = "";
        }
        String string4 = OdxCLJStatus.makeOptionString(properties);
        byte[] byArray = OdxCLJNative.connect(OdxCLJNative.getBytes(string), OdxCLJNative.getBytes(string4), this.m_oaStatus, OdxCLJNative.getBytes(string3), OdxCLJNative.getBytes(string2), this.m_instance);
        int n = this.m_oaStatus[0];
        if (n != 0) {
            OdxCLJNative.disconnect(this.m_instance, this.m_oaStatus);
            throw OdxCLJException.error(byArray, n);
        }
        this.m_endian = OdxCLJNative.getEndianFlag(this.m_instance);
        this.m_readOnly = OdxCLJNative.getReadOnlyFlag(this.m_instance);
        this.m_oaVersion = new String(OdxCLJNative.getOaVersion(this.m_instance));
        this.m_environmentName = new String(OdxCLJNative.getEnvironmentName(this.m_instance));
        this.m_environmentFile = new String(OdxCLJNative.getEnvironmentFile(this.m_instance));
        this.setDefaultTimezone();
        this.trace("OA Version     : " + this.m_oaVersion);
        this.trace("ODBCSRV Version: " + new String(OdxCLJNative.getOdbcSrvVersion(this.m_instance)));
        this.trace("OdxJDBC Version: " + new String(OdxCLJStatus.getDriverVersion()));
        this.trace("Timezone       : " + this.m_timezone);
        byArray = null;
    }

    protected byte[] executeSQL(String string, Properties properties, int n) throws SQLException {
        OdxCLJTrace.print("executeSQL: " + string);
        byte[] byArray = OdxCLJNative.executeSQL(this.m_instance, this.m_oaStatus, OdxCLJNative.getBytes(OdxCLJStatus.makeOptionString(properties)), n, OdxCLJNative.getBytes(string));
        if (this.m_oaStatus[0] != 0) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
        this.checkForSetTimezone(string);
        return byArray;
    }

    protected void executeUpdate(String string) throws SQLException {
        OdxCLJTrace.print("executeUpdate: " + string);
        int n = this.replaceStatusCursor(this.m_updateCursor);
        byte[] byArray = OdxCLJNative.executeSQL(this.m_instance, this.m_oaStatus, OdxCLJNative.getBytes(""), 0, OdxCLJNative.getBytes(string));
        this.m_updateCursor = this.replaceStatusCursor(n);
        if (this.m_oaStatus[0] != 0) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
        byArray = null;
        this.checkForSetTimezone(string);
    }

    private void checkForSetTimezone(String string) {
        if ((string = string.trim().toUpperCase()).startsWith("SET ") && (string = string.substring(4).trim()).startsWith("TIMEZONE ")) {
            int n = (string = string.substring(9).trim()).indexOf(32);
            if (n != -1) {
                string = string.substring(0, n).trim();
            }
            if (string.startsWith("DEFAULT")) {
                this.setDefaultTimezone();
            } else {
                this.m_timezone = string;
            }
        }
    }

    private void setDefaultTimezone() {
        this.m_timezone = new String(OdxCLJNative.getTimezone(this.m_instance));
        if (this.m_timezone == null) {
            this.m_timezone = "";
        }
    }

    protected void fetch(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws SQLException {
        byte[] byArray4 = OdxCLJNative.fetch(this.m_instance, this.m_oaStatus, n, byArray, byArray2, byArray3);
        if (byArray4 != null) {
            throw OdxCLJException.error(byArray4, this.m_oaStatus[0]);
        }
    }

    protected String getVersion() {
        return this.m_oaVersion;
    }

    protected String getEnvironmentName() {
        return this.m_environmentName;
    }

    protected String getEnvironmentFile() {
        return this.m_environmentFile;
    }

    protected int getDatabaseCount() throws SQLException {
        if (this.m_databaseInfo == null) {
            byte[] byArray = OdxCLJNative.getDatabaseInfo(this.m_instance, this.m_oaStatus);
            if (this.m_oaStatus[0] != 0) {
                throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
            }
            this.m_databaseInfo = byArray;
        }
        return OdxCLJNative.getInfoCount(this.m_databaseInfo);
    }

    protected String getDatabaseName(int n) {
        return new String(OdxCLJNative.getDatabaseName(this.m_databaseInfo, n));
    }

    protected byte[] getTableInfo(String string, String string2, String string3, int n) throws SQLException {
        byte[] byArray = OdxCLJNative.getTableInfo(this.m_instance, this.m_oaStatus, OdxCLJNative.getBytes(string), OdxCLJNative.getBytes(string2), OdxCLJNative.getBytes(string3), n);
        if (this.m_oaStatus[0] != 0) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected byte[] getColumnInfo(String string, String string2, String string3, String string4) throws SQLException {
        byte[] byArray = OdxCLJNative.getColumnInfo(this.m_instance, this.m_oaStatus, OdxCLJNative.getBytes(string), OdxCLJNative.getBytes(string2), OdxCLJNative.getBytes(string3), OdxCLJNative.getBytes(string4));
        if (this.m_oaStatus[0] != 0) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected byte[] getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        byte[] byArray = OdxCLJNative.getPrimaryKeys(this.m_instance, this.m_oaStatus, OdxCLJNative.getBytes(string), OdxCLJNative.getBytes(string2), OdxCLJNative.getBytes(string3));
        if (this.m_oaStatus[0] != 0) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected byte[] getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        byte[] byArray = OdxCLJNative.getIndexInfo(this.m_instance, this.m_oaStatus, OdxCLJNative.getBytes(string), OdxCLJNative.getBytes(string2), OdxCLJNative.getBytes(string3), bl, bl2);
        if (this.m_oaStatus[0] != 0) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected byte[] getComponentInfo(String string, String string2, String string3, String string4) throws SQLException {
        byte[] byArray = OdxCLJNative.getComponentInfo(this.m_instance, this.m_oaStatus, OdxCLJNative.getBytes(string), OdxCLJNative.getBytes(string2), OdxCLJNative.getBytes(string3), OdxCLJNative.getBytes(string4));
        if (this.m_oaStatus[0] != 0) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
        return byArray;
    }

    protected char parseSqlEscapeOption(String string) {
        return OdxCLJNative.parseSqlEscapeOption(this.m_instance, this.m_oaStatus, OdxCLJNative.getBytes(string));
    }

    protected void cancel() throws SQLException {
        byte[] byArray = OdxCLJNative.cancel(this.m_instance, this.m_oaStatus);
        if (byArray != null) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
    }

    protected void closeCursor() throws SQLException {
        if (this.getStatusCursor() != 0 || this.m_updateCursor != 0) {
            this.m_oaStatus[8] = this.m_updateCursor;
            byte[] byArray = OdxCLJNative.closeCursor(this.m_instance, this.m_oaStatus);
            if (byArray != null) {
                throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
            }
            this.m_updateCursor = 0;
            this.m_oaStatus[10] = 0;
        }
    }

    protected void disconnect() throws SQLException {
        this.closeCursor();
        byte[] byArray = OdxCLJNative.disconnect(this.m_instance, this.m_oaStatus);
        if (byArray != null) {
            throw OdxCLJException.error(byArray, this.m_oaStatus[0]);
        }
        this.m_oaStatus[10] = 0;
        this.m_oaStatus[9] = 0;
        this.m_oaStatus[0] = 0;
    }
}

