/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import omnidex.client.OdxCLJConnection;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCDatabaseMetaData;
import omnidex.jdbc.OdxJDBCPreparedStatement;
import omnidex.jdbc.OdxJDBCStatement;

public final class OdxJDBCConnection
implements Connection {
    private OdxCLJConnection m_oaConnection;
    private DatabaseMetaData m_dbMetaData;
    private ArrayList<OdxJDBCStatement> m_jdbcStatements;
    private Map<String, Class<?>> m_typeMap;
    private boolean m_noThread;
    private boolean m_strictCheck;

    protected OdxJDBCConnection() {
        this.trace(null);
        this.m_jdbcStatements = new ArrayList();
        this.m_typeMap = new HashMap();
        this.m_noThread = false;
    }

    protected void open(String string, Properties properties, boolean bl) throws SQLException {
        this.trace("initialize");
        this.m_oaConnection = new OdxCLJConnection();
        this.m_oaConnection.open(string, properties, bl);
        this.m_strictCheck = bl;
    }

    protected OdxCLJConnection getOaConnection() {
        return this.m_oaConnection;
    }

    protected void checkConnection() throws SQLException {
        if (this.m_oaConnection == null) {
            throw OdxCLJException.error(25502);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatements() throws SQLException {
        this.trace("closeStatements");
        ArrayList<OdxJDBCStatement> arrayList = this.m_jdbcStatements;
        synchronized (arrayList) {
            Iterator<OdxJDBCStatement> iterator = this.m_jdbcStatements.iterator();
            while (iterator.hasNext()) {
                iterator.next().connectionClosed();
            }
            this.m_jdbcStatements.clear();
        }
    }

    private void closeConnection() throws SQLException {
        this.trace("closeConnection");
        if (this.m_oaConnection != null) {
            this.m_oaConnection.close();
            this.m_oaConnection = null;
        }
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected void dump() {
        OdxCLJTrace.print("Inside " + this);
        OdxCLJTrace.print(" - " + this.m_oaConnection);
        for (int i = 0; i < this.m_jdbcStatements.size(); ++i) {
            this.m_jdbcStatements.get(i).dump();
        }
    }

    public void setCheck(boolean bl) {
        if (this.m_oaConnection != null) {
            this.m_oaConnection.setCheck(bl);
        }
        this.m_strictCheck = bl;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.trace("nativeSQL");
        return string;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        if (!bl && this.m_strictCheck) {
            throw OdxCLJException.error(25509);
        }
    }

    @Override
    public boolean getAutoCommit() {
        return true;
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() throws SQLException {
        throw OdxCLJException.error(25508);
    }

    @Override
    public void close() throws SQLException {
        this.trace("close");
        this.closeStatements();
        this.closeConnection();
    }

    @Override
    public boolean isClosed() {
        return this.m_oaConnection == null;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.trace("getMetaData");
        this.checkConnection();
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new OdxJDBCDatabaseMetaData(this, this.m_oaConnection);
        }
        return this.m_dbMetaData;
    }

    public void setNoThread(boolean bl) throws SQLException {
        this.m_noThread = bl;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (bl != this.m_oaConnection.isReadOnly() && this.m_strictCheck) {
            throw OdxCLJException.error(25510);
        }
    }

    @Override
    public boolean isReadOnly() {
        boolean bl = false;
        try {
            bl = this.m_oaConnection.isReadOnly();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void setCatalog(String string) {
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkConnection();
        return this.m_oaConnection.getEnvironmentFile();
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        if (n != 0 && this.m_strictCheck) {
            throw OdxCLJException.error(25511);
        }
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.trace("createStatement");
        this.checkConnection();
        OdxJDBCStatement odxJDBCStatement = new OdxJDBCStatement(this);
        odxJDBCStatement.initialize(this.m_oaConnection, n, n2, this.m_noThread);
        ArrayList<OdxJDBCStatement> arrayList = this.m_jdbcStatements;
        synchronized (arrayList) {
            this.m_jdbcStatements.add(odxJDBCStatement);
        }
        return odxJDBCStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkConnection();
        OdxJDBCPreparedStatement odxJDBCPreparedStatement = new OdxJDBCPreparedStatement(this);
        odxJDBCPreparedStatement.initialize(this.m_oaConnection, string, n, n2, this.m_noThread);
        ArrayList<OdxJDBCStatement> arrayList = this.m_jdbcStatements;
        synchronized (arrayList) {
            this.m_jdbcStatements.add(odxJDBCPreparedStatement);
        }
        return odxJDBCPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.trace("prepareCall");
        throw OdxCLJException.error(25507);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return this.m_typeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
        this.m_typeMap = map;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (n != 1 && this.m_strictCheck) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 != 1 && this.m_strictCheck) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement(n, n2);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 != 1 && this.m_strictCheck) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(string, n, n2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public void setSchema(String string) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

