/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import omnidex.client.OdxCLJException;
import omnidex.jdbc.OdxJDBCRouterConnection;
import omnidex.jdbc.OdxJDBCRouterStatement;

public final class OdxJDBCRouterPreparedStatement
extends OdxJDBCRouterStatement
implements PreparedStatement {
    private String m_sql;

    protected OdxJDBCRouterPreparedStatement(OdxJDBCRouterConnection odxJDBCRouterConnection) {
        super(odxJDBCRouterConnection);
    }

    protected void initialize(String string) throws SQLException {
        this.m_sql = this.processRule(string);
        this.createStatement(this.m_sql);
    }

    protected void initialize(String string, int n, int n2) throws SQLException {
        this.m_sql = this.processRule(string);
        this.initialize(n, n2);
        this.createStatement(this.m_sql);
    }

    protected void initialize(String string, int n, int n2, int n3) throws SQLException {
        this.m_sql = this.processRule(string);
        this.initialize(n, n2, n3);
        this.createStatement(this.m_sql);
    }

    private void checkStatement() throws SQLException {
        if (this.m_statement == null) {
            throw OdxCLJException.error(25504);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkStatement();
        ResultSet resultSet = null;
        try {
            resultSet = ((PreparedStatement)this.m_statement).executeQuery();
        }
        catch (SQLException sQLException) {
            String string = null;
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string = this.processRule(this.m_sql, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string = this.processRule(this.m_sql, this.m_onErrorRule);
            }
            this.createStatement(string);
            resultSet = ((PreparedStatement)this.m_statement).executeQuery();
        }
        return resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkStatement();
        int n = 0;
        try {
            n = ((PreparedStatement)this.m_statement).executeUpdate();
        }
        catch (SQLException sQLException) {
            String string = null;
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string = this.processRule(this.m_sql, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string = this.processRule(this.m_sql, this.m_onErrorRule);
            }
            this.createStatement(string);
            n = ((PreparedStatement)this.m_statement).executeUpdate();
        }
        return n;
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setNull(n, n2);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBoolean(n, bl);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setByte(n, by);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setShort(n, s);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setInt(n, n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setLong(n, l);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setFloat(n, f);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setDouble(n, d);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBigDecimal(n, bigDecimal);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setString(n, string);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBytes(n, byArray);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setDate(n, date);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setTime(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setTimestamp(n, timestamp);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setAsciiStream(n, inputStream, n2);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setUnicodeStream(n, inputStream, n2);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBinaryStream(n, inputStream, n2);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).clearParameters();
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setObject(n, object, n2, n3);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setObject(n, object, n2);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setObject(n, object);
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkStatement();
        boolean bl = false;
        try {
            bl = ((PreparedStatement)this.m_statement).execute();
        }
        catch (SQLException sQLException) {
            String string = null;
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string = this.processRule(this.m_sql, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string = this.processRule(this.m_sql, this.m_onErrorRule);
            }
            this.createStatement(string);
            bl = ((PreparedStatement)this.m_statement).execute();
        }
        return bl;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).addBatch();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setCharacterStream(n, reader, n2);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setRef(n, ref);
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setBlob(n, blob);
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setClob(n, clob);
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setArray(n, array);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkStatement();
        return ((PreparedStatement)this.m_statement).getMetaData();
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setDate(n, date, calendar);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setTime(n, time, calendar);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setTimestamp(n, timestamp, calendar);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkStatement();
        ((PreparedStatement)this.m_statement).setNull(n, n2, string);
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

