/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.regex.Pattern;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCRouterConnection;
import omnidex.jdbc.OdxJDBCRouterRule;
import omnidex.xml.OdxJDBCIR.ConditionsType;
import omnidex.xml.OdxJDBCIR.RuleTypeType;

public class OdxJDBCRouterStatement
implements Statement {
    protected OdxJDBCRouterConnection m_connection;
    protected Connection m_jdbcConnection;
    protected Statement m_statement;
    protected String m_onErrorRule;
    protected String m_onTimeoutRule;
    private Integer m_resultSetType;
    protected Integer m_resultSetConcurrency;
    protected Integer m_holdability;
    private Integer m_maxFieldSize;
    private Integer m_maxRows;
    private Boolean m_escape;
    private Integer m_queryTimeout;
    private Integer m_fetchDirection;
    private Integer m_fetchSize;

    protected OdxJDBCRouterStatement(OdxJDBCRouterConnection odxJDBCRouterConnection) {
        this.m_connection = odxJDBCRouterConnection;
    }

    protected void initialize(int n, int n2) {
        this.m_resultSetType = n;
        this.m_resultSetConcurrency = n2;
    }

    protected void initialize(int n, int n2, int n3) {
        this.initialize(n, n2);
        this.m_holdability = n3;
    }

    private void createStatement() throws SQLException {
        this.createStatement(null);
    }

    protected void createStatement(String string) throws SQLException {
        this.m_statement = this.m_resultSetType != null || this.m_resultSetConcurrency != null ? (this.m_holdability != null ? (string == null ? this.m_jdbcConnection.createStatement(this.m_resultSetType, this.m_resultSetConcurrency, this.m_holdability) : this.m_jdbcConnection.prepareStatement(string, this.m_resultSetType, this.m_resultSetConcurrency, this.m_holdability)) : (string == null ? this.m_jdbcConnection.createStatement(this.m_resultSetType, this.m_resultSetConcurrency) : this.m_jdbcConnection.prepareStatement(string, this.m_resultSetType, this.m_resultSetConcurrency))) : (string == null ? this.m_jdbcConnection.createStatement() : this.m_jdbcConnection.prepareStatement(string));
        if (this.m_maxFieldSize != null) {
            this.m_statement.setMaxFieldSize(this.m_maxFieldSize);
        }
        if (this.m_maxRows != null) {
            this.m_statement.setMaxRows(this.m_maxRows);
        }
        if (this.m_escape != null) {
            this.m_statement.setEscapeProcessing(this.m_escape);
        }
        if (this.m_queryTimeout != null) {
            this.m_statement.setQueryTimeout(this.m_queryTimeout);
        }
        if (this.m_fetchDirection != null) {
            this.m_statement.setFetchDirection(this.m_fetchDirection);
        }
        if (this.m_fetchSize != null) {
            this.m_statement.setFetchSize(this.m_fetchSize);
        }
    }

    protected void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected void trace(Exception exception) {
        OdxCLJTrace.print(exception);
    }

    protected String processRule(String string) throws SQLException {
        return this.processRule(string, null);
    }

    /*
     * Unable to fully structure code
     */
    protected String processRule(String var1_1, String var2_2) throws SQLException {
        if (this.m_statement != null) {
            this.m_statement.close();
        }
        if (this.m_jdbcConnection != null) {
            this.m_jdbcConnection.close();
        }
        this.m_onTimeoutRule = null;
        this.m_onErrorRule = null;
        var3_3 = this.m_connection.getRule(var2_2);
        this.trace("Processing rule " + var3_3.getName() + " for the following sql: " + var1_1);
        var4_4 = null;
        var5_5 = var3_3.getType();
        if (var5_5 == RuleTypeType.JAVA) {
            var6_6 = var3_3.getClassName();
            this.trace("Executing method from the following class: " + (String)var6_6);
            try {
                var7_7 = Class.forName((String)var6_6);
                var8_12 = var7_7.getDeclaredConstructor(new Class[0]);
                var9_14 = (OdxJDBCRouterRule)var8_12.newInstance(new Object[0]);
                var9_14.setSql(var1_1);
                var9_14.setServerList(this.m_connection.getServerList());
                var4_4 = var9_14.process();
                if (var4_4 != null) {
                    this.trace("Method returns a server object: " + var4_4.getName());
                    var10_16 = var9_14.getSql();
                    this.trace("Sql: " + var10_16);
                    if (var10_16.equals(var1_1)) ** GOTO lbl51
                    this.trace("Original sql: " + var1_1);
                    var1_1 = var10_16;
                }
                this.trace("Method returns a null server");
            }
            catch (ClassNotFoundException var7_8) {
                throw OdxCLJException.error(25554, (String)var6_6);
            }
            catch (InstantiationException var7_9) {
                throw OdxCLJException.error(var7_9);
            }
            catch (Exception var7_10) {
                throw OdxCLJException.error(var7_10);
            }
        } else if (var5_5 == RuleTypeType.REGEXP) {
            var6_6 = var3_3.getConditions();
            var7_11 = var6_6.getCondition();
            for (ConditionsType.Condition var9_15 : var7_11) {
                var10_17 = var9_15.getRegexp();
                this.trace("Regexp processed: " + var10_17);
                var11_18 = Pattern.compile(var10_17);
                var12_19 = var11_18.matcher(var1_1);
                if (var12_19.find()) {
                    var4_4 = this.m_connection.getServer(var9_15.getServer());
                    this.trace("Matched, server used: " + var4_4.getName());
                    break;
                }
                this.trace("No match");
            }
        }
lbl51:
        // 7 sources

        if (var4_4 == null && (var6_6 = var3_3.getDefaultServer()) != null && (var4_4 = this.m_connection.getServer((String)var6_6)) != null) {
            this.trace("Use default server: " + var4_4.getName());
        }
        this.m_jdbcConnection = this.m_connection.getConnection(var4_4);
        this.m_onErrorRule = var3_3.getOnErrorRule();
        this.m_onTimeoutRule = var3_3.getOnTimeoutRule();
        return var1_1;
    }

    protected boolean isTimeoutError(SQLException sQLException) {
        boolean bl;
        String string = sQLException.getSQLState();
        boolean bl2 = bl = string != null && string.equals("HYT00");
        if (bl) {
            this.trace("Timeout occurred.");
        }
        return bl;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        String string2 = this.processRule(string);
        this.createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = this.m_statement.executeQuery(string2);
        }
        catch (SQLException sQLException) {
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string2 = this.processRule(string, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string2 = this.processRule(string, this.m_onErrorRule);
            }
            this.createStatement();
            resultSet = this.m_statement.executeQuery(string2);
        }
        return resultSet;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        String string2 = this.processRule(string);
        this.createStatement();
        int n = 0;
        try {
            n = this.m_statement.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string2 = this.processRule(string, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string2 = this.processRule(string, this.m_onErrorRule);
            }
            this.createStatement();
            n = this.m_statement.executeUpdate(string2);
        }
        return n;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_statement != null) {
            this.m_statement.close();
            this.m_statement = null;
        }
        if (this.m_jdbcConnection != null) {
            this.m_jdbcConnection.close();
            this.m_jdbcConnection = null;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.m_statement != null ? this.m_statement.getMaxFieldSize() : this.m_maxFieldSize.intValue();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.m_maxFieldSize = n;
        if (this.m_statement != null) {
            this.m_statement.setMaxFieldSize(n);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.m_statement != null ? this.m_statement.getMaxRows() : this.m_maxRows.intValue();
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.m_maxRows = n;
        if (this.m_statement != null) {
            this.m_statement.setMaxRows(n);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.m_escape = bl;
        if (this.m_statement != null) {
            this.m_statement.setEscapeProcessing(bl);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.m_statement != null ? this.m_statement.getQueryTimeout() : this.m_queryTimeout.intValue();
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.m_queryTimeout = n;
        if (this.m_statement != null) {
            this.m_statement.setQueryTimeout(n);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.m_statement != null) {
            this.m_statement.cancel();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.m_statement != null ? this.m_statement.getWarnings() : null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.m_statement != null) {
            this.m_statement.clearWarnings();
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public boolean execute(String string) throws SQLException {
        String string2 = this.processRule(string);
        this.createStatement();
        boolean bl = false;
        try {
            bl = this.m_statement.execute(string2);
        }
        catch (SQLException sQLException) {
            if (this.m_onTimeoutRule != null && this.isTimeoutError(sQLException)) {
                string2 = this.processRule(string, this.m_onTimeoutRule);
            } else {
                if (this.m_onErrorRule == null) {
                    throw sQLException;
                }
                this.trace(sQLException);
                string2 = this.processRule(string, this.m_onErrorRule);
            }
            this.createStatement();
            bl = this.m_statement.execute(string2);
        }
        return bl;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.m_statement != null ? this.m_statement.getResultSet() : null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.m_statement != null ? this.m_statement.getUpdateCount() : -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.m_statement != null ? this.m_statement.getMoreResults() : false;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.m_fetchDirection = n;
        if (this.m_statement != null) {
            this.m_statement.setFetchDirection(n);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.m_statement != null ? this.m_statement.getFetchDirection() : this.m_fetchDirection.intValue();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.m_fetchSize = n;
        if (this.m_statement != null) {
            this.m_statement.setFetchSize(n);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.m_statement != null ? this.m_statement.getFetchSize() : this.m_fetchSize.intValue();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.m_statement != null ? this.m_statement.getResultSetConcurrency() : this.m_resultSetConcurrency.intValue();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.m_statement != null ? this.m_statement.getResultSetType() : this.m_resultSetType.intValue();
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void clearBatch() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_connection;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        return this.m_statement != null ? this.m_statement.getMoreResults(n) : false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.m_statement != null ? this.m_statement.getResultSetHoldability() : this.m_holdability.intValue();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_statement == null || this.m_statement.isClosed();
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

