/*
 * Decompiled with CFR 0.152.
 */
package omnidex.client;

import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJNative;
import omnidex.client.OdxCLJResultSet;
import omnidex.client.OdxCLJStatement;
import omnidex.client.OdxCLJStatus;
import omnidex.client.OdxCLJTrace;

public final class OdxCLJDataResultSet
extends OdxCLJResultSet {
    private int m_rowSize;
    private ArrayList<OdxCLJRowset> m_rowset;
    private int m_rowsetIndex;
    private byte[] m_fetchBuffer;
    private byte[] m_nullIndBuffer;
    private int m_bufferRowCount;
    private int m_bufferSizeDefault = 48000;
    private int m_fetchRowRequest;
    private int m_minRowsToFetch = 32;
    private int m_fetchRowCount;
    private int m_fetchStartRow;
    private int m_totalRowCount;
    private String[] m_updateBuffer;
    private boolean[] m_updateFlags;
    private byte[] m_oaResult;
    private int m_endian;
    private OdxCLJStatus m_status;
    private OdxCLJStatement m_statement;

    protected OdxCLJDataResultSet(OdxCLJStatement odxCLJStatement, OdxCLJStatus odxCLJStatus, byte[] byArray, int n) {
        this.m_statement = odxCLJStatement;
        this.m_status = odxCLJStatus;
        this.m_endian = n;
        this.m_oaResult = byArray;
    }

    protected void initialize() throws SQLException {
        int n = this.m_status.getStatusColumnCount();
        if (n == 0) {
            throw OdxCLJException.error(25501);
        }
        this.setColumnCount(n);
        if (this.getConcurrency() == 1008 && this.m_status.getStatusUpdateFlag() == 0) {
            this.setConcurrency(1007);
        }
        this.m_rowSize = this.m_status.getStatusBufferLength();
        for (int i = 1; i <= n; ++i) {
            this.setColumnInfo(i, new String(OdxCLJNative.getResultSetInfoString(this.m_oaResult, 7, i)), OdxCLJNative.getResultSetInfoInt(this.m_oaResult, 9, i), OdxCLJNative.getResultSetInfoInt(this.m_oaResult, 10, i), OdxCLJNative.getResultSetInfoInt(this.m_oaResult, 12, i), OdxCLJNative.getResultSetInfoInt(this.m_oaResult, 13, i));
        }
        this.m_fetchRowRequest = this.calcRowsRequested();
        this.m_fetchStartRow = 1;
        if (this.getMaxRows() != 0) {
            this.m_totalRowCount = this.getMaxRows();
        }
    }

    private int getResultSetInfoInt(int n, int n2) throws SQLException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return OdxCLJNative.getResultSetInfoInt(this.m_oaResult, n2, n);
    }

    private String getResultSetInfoString(int n, int n2) throws SQLException {
        this.checkResultSet();
        this.checkColumnNumber(n);
        return new String(OdxCLJNative.getResultSetInfoString(this.m_oaResult, n2, n));
    }

    @Override
    protected String getValueString(int n) {
        return this.getValueString(n, false);
    }

    @Override
    protected String getValueString(int n, boolean bl) {
        if (this.isQueryMode()) {
            String string = new String(OdxCLJNative.getColumnValueString(this.m_fetchBuffer, this.m_oaResult, this.getRow() - this.m_fetchStartRow + 1, n, this.m_rowSize));
            if (bl && string != null) {
                string = string.trim();
            }
            return string;
        }
        if (this.m_updateBuffer != null) {
            return this.m_updateBuffer[n];
        }
        return null;
    }

    @Override
    protected boolean getValueBoolean(int n) {
        if (this.isQueryMode()) {
            return OdxCLJNative.getColumnValueBoolean(this.m_fetchBuffer, this.m_oaResult, this.getRow() - this.m_fetchStartRow + 1, n, this.m_rowSize);
        }
        if (this.m_updateBuffer != null && this.m_updateBuffer[n] != null) {
            return Boolean.valueOf(this.m_updateBuffer[n]);
        }
        return false;
    }

    @Override
    protected long getValueBigInt(int n) {
        if (this.isQueryMode()) {
            return OdxCLJNative.getColumnValueBigInt(this.m_fetchBuffer, this.m_oaResult, this.getRow() - this.m_fetchStartRow + 1, n, this.m_rowSize, this.m_endian);
        }
        if (this.m_updateBuffer != null) {
            return Long.valueOf(this.m_updateBuffer[n]);
        }
        return 0L;
    }

    @Override
    protected String getValueStringBigInt(int n) {
        if (this.isQueryMode()) {
            return new String(OdxCLJNative.getColumnValueStringBigInt(this.m_fetchBuffer, this.m_oaResult, this.getRow() - this.m_fetchStartRow + 1, n, this.m_rowSize, this.m_endian));
        }
        if (this.m_updateBuffer != null) {
            return this.m_updateBuffer[n];
        }
        return null;
    }

    @Override
    protected int getValueInt(int n) {
        if (this.isQueryMode()) {
            return OdxCLJNative.getColumnValueInt(this.m_fetchBuffer, this.m_oaResult, this.getRow() - this.m_fetchStartRow + 1, n, this.m_rowSize, this.m_endian);
        }
        if (this.m_updateBuffer != null && this.m_updateBuffer[n] != null) {
            return Integer.valueOf(this.m_updateBuffer[n]);
        }
        return 0;
    }

    @Override
    protected double getValueDouble(int n) {
        if (this.isQueryMode()) {
            return OdxCLJNative.getColumnValueDouble(this.m_fetchBuffer, this.m_oaResult, this.getRow() - this.m_fetchStartRow + 1, n, this.m_rowSize, this.m_endian);
        }
        if (this.m_updateBuffer != null && this.m_updateBuffer[n] != null) {
            return Double.valueOf(this.m_updateBuffer[n]);
        }
        return 0.0;
    }

    @Override
    protected long getValueTimestamp(int n) {
        if (this.isQueryMode()) {
            Calendar calendar;
            int[] nArray = OdxCLJNative.getColumnValueTimestamp(this.m_fetchBuffer, this.m_oaResult, this.getRow() - this.m_fetchStartRow + 1, n, this.m_rowSize, this.m_endian);
            if (nArray == null) {
                return 0L;
            }
            if (nArray[0] == -1 && nArray[1] == -1 && nArray[2] == -1) {
                OdxCLJTrace.print(String.format("Time value: %d,%d,%d", nArray[3], nArray[4], nArray[5]));
                calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                calendar.set(0, 0, 0, nArray[3], nArray[4], nArray[5]);
                calendar.set(14, 0);
            } else if (nArray[3] == -1 && nArray[4] == -1 && nArray[5] == -1) {
                OdxCLJTrace.print(String.format("Date value: %d,%d,%d", nArray[0], nArray[1] - 1, nArray[2]));
                calendar = Calendar.getInstance(TimeZone.getTimeZone(this.m_status.getTimezone()));
                calendar.set(nArray[0], nArray[1] - 1, nArray[2], 0, 0, 0);
                calendar.set(14, 0);
            } else {
                if (nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4] + nArray[5] + nArray[6] == 0) {
                    return 0L;
                }
                OdxCLJTrace.print(String.format("Timestamp value: %d,%d,%d,%d,%d,%d,%d", nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6]));
                calendar = Calendar.getInstance(TimeZone.getTimeZone(this.m_status.getTimezone()));
                calendar.set(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
                calendar.set(14, nArray[6] / 10000000);
            }
            return calendar.getTimeInMillis();
        }
        if (this.m_updateBuffer != null && this.m_updateBuffer[n] != null) {
            Date date;
            try {
                date = DateFormat.getDateInstance().parse(this.m_updateBuffer[n]);
            }
            catch (ParseException parseException) {
                return 0L;
            }
            return date.getTime();
        }
        return 0L;
    }

    @Override
    protected boolean getNullFlag(int n) {
        if (!this.isQueryMode()) {
            return false;
        }
        return OdxCLJNative.getColumnNullFlag(this.m_nullIndBuffer, this.getRow() - this.m_fetchStartRow + 1, n, this.getColumnCount());
    }

    @Override
    protected String getTimezone() {
        return this.m_status.getTimezone();
    }

    private int calcRowsRequested() {
        int n = this.getFetchSize();
        if (n > 0) {
            return n;
        }
        n = this.m_bufferSizeDefault / this.m_rowSize;
        if (n < this.m_minRowsToFetch) {
            n = this.m_minRowsToFetch;
        }
        return n;
    }

    private void saveRowset() {
        if (this.m_rowset == null) {
            this.m_rowset = new ArrayList();
        }
        this.m_rowset.add(new OdxCLJRowset(this.m_fetchBuffer, this.m_nullIndBuffer, this.m_fetchStartRow, this.m_fetchRowCount));
        this.m_rowsetIndex = this.m_rowset.size() - 1;
    }

    private void setRowset(int n) throws SQLException {
        if (n >= this.m_rowset.size()) {
            this.setRowset(this.m_rowset.size() - 1);
            while (n >= this.m_rowset.size()) {
                this.setRow(this.m_fetchStartRow + this.m_fetchRowCount - 1);
                if (this.next()) continue;
                return;
            }
        }
        if (n != this.m_rowsetIndex) {
            OdxCLJRowset odxCLJRowset = this.m_rowset.get(n);
            this.m_fetchBuffer = odxCLJRowset.m_fetchBuffer;
            this.m_nullIndBuffer = odxCLJRowset.m_nullIndBuffer;
            this.m_fetchStartRow = odxCLJRowset.m_fetchStartRow;
            this.m_fetchRowCount = odxCLJRowset.m_fetchRowCount;
            this.m_rowsetIndex = n;
        }
    }

    private void traceInfo(String string) {
        OdxCLJTrace.print(string + this.getRow() + "," + this.m_fetchStartRow + "," + this.m_fetchRowCount + "," + this.m_rowsetIndex + "," + this.m_totalRowCount);
    }

    private static String fixString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        if (string.indexOf("'") != -1) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\'' && n != 92) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                n = c;
            }
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    private String assembleWhere() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" where ");
        int n = this.getMode();
        this.setQueryMode();
        boolean bl = true;
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" and ");
            }
            String string = this.getColumnValueString(i);
            stringBuffer.append("\"");
            stringBuffer.append(this.getColumnName(i));
            stringBuffer.append("\"=");
            stringBuffer.append(string == null ? "' '" : OdxCLJDataResultSet.fixString(string.trim()));
        }
        this.setMode(n);
        return stringBuffer.toString();
    }

    private int executeUpdate(String string) throws SQLException {
        int n = 0;
        this.m_status.executeUpdate(string);
        if (this.m_status.getStatusColumnCount() == 0) {
            n = (int)this.m_status.getStatusCount();
        }
        return n;
    }

    @Override
    public int getType(int n) throws SQLException {
        return this.getResultSetInfoInt(n, 1);
    }

    @Override
    public int getSubtype(int n) throws SQLException {
        return this.getResultSetInfoInt(n, 2);
    }

    @Override
    public String getColumnEnvironment(int n) throws SQLException {
        return this.getResultSetInfoString(n, 3);
    }

    @Override
    public String getColumnDatabase(int n) throws SQLException {
        return this.getResultSetInfoString(n, 4);
    }

    @Override
    public String getColumnTable(int n) throws SQLException {
        return this.getResultSetInfoString(n, 5);
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.getResultSetInfoString(n, 6);
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.getResultSetInfoString(n, 7);
    }

    @Override
    public String getAlias(int n) throws SQLException {
        return this.getResultSetInfoString(n, 8);
    }

    @Override
    public int getOaDatatype(int n) throws SQLException {
        int n2 = this.getResultSetInfoInt(n, 20);
        if (n2 == 0) {
            n2 = this.getResultSetInfoInt(n, 16);
        }
        return n2;
    }

    @Override
    public int getOaLength(int n) throws SQLException {
        int n2 = this.getResultSetInfoInt(n, 21);
        if (n2 == 0) {
            n2 = this.getResultSetInfoInt(n, 17);
        }
        return n2;
    }

    @Override
    public int getOccurrences(int n) throws SQLException {
        return this.getResultSetInfoInt(n, 11);
    }

    @Override
    public int getUsage(int n) throws SQLException {
        return this.getResultSetInfoInt(n, 14);
    }

    @Override
    public String getOptions(int n) throws SQLException {
        return this.getResultSetInfoString(n, 15);
    }

    @Override
    public int getRequiredDatatype(int n) throws SQLException {
        return this.getResultSetInfoInt(n, 16);
    }

    @Override
    public int getRequiredLength(int n) throws SQLException {
        return this.getResultSetInfoInt(n, 17);
    }

    @Override
    public int getRequiredUsage(int n) throws SQLException {
        return this.getResultSetInfoInt(n, 18);
    }

    @Override
    public String getRequiredOptions(int n) throws SQLException {
        return this.getResultSetInfoString(n, 19);
    }

    @Override
    public void setFetchSize(int n) {
        this.traceInfo("setFetchSize: size: " + n);
        super.setFetchSize(n);
        this.m_fetchRowRequest = n == 0 ? this.calcRowsRequested() : n;
    }

    @Override
    public boolean isReadOnly(int n) {
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        this.traceInfo("next: ");
        this.setQueryMode();
        if (this.m_totalRowCount != 0 && this.getRow() >= this.m_totalRowCount) {
            if (this.getRow() == this.m_totalRowCount) {
                this.setRow(this.getRow() + 1);
            }
            return false;
        }
        this.setRow(this.getRow() + 1);
        if (this.getRow() < this.m_fetchStartRow + this.m_fetchRowCount) {
            return true;
        }
        if (this.getType() != 1003) {
            if (this.m_rowset != null && this.m_rowsetIndex + 1 < this.m_rowset.size()) {
                this.setRowset(this.m_rowsetIndex + 1);
                return true;
            }
            this.m_bufferRowCount = 0;
        }
        byte[] byArray = this.m_fetchBuffer;
        byte[] byArray2 = this.m_nullIndBuffer;
        int n = this.m_fetchStartRow + this.m_fetchRowCount;
        if (this.m_bufferRowCount != this.m_fetchRowRequest) {
            byArray = new byte[this.m_fetchRowRequest * this.m_rowSize + 2];
            byArray2 = new byte[this.m_fetchRowRequest * this.getColumnCount() + 2];
            this.m_bufferRowCount = this.m_fetchRowRequest;
        }
        this.m_status.fetch(byArray, byArray2, this.m_fetchRowRequest, this.m_oaResult);
        int n2 = (int)this.m_status.getStatusCount();
        OdxCLJTrace.print("Fetch Count: " + n2);
        if (n2 != 0) {
            this.m_fetchBuffer = byArray;
            this.m_nullIndBuffer = byArray2;
            this.m_fetchRowCount = n2;
            this.m_fetchStartRow = n;
        }
        if (n2 < this.m_fetchRowRequest) {
            this.m_statement.unlockConnection();
            this.m_totalRowCount = n + n2 - 1;
            OdxCLJTrace.print("Total Row: " + this.m_totalRowCount);
        }
        if (n2 != 0) {
            if (this.getType() != 1003) {
                this.saveRowset();
            }
        } else if (this.getRow() == 1) {
            this.setRow(0);
        }
        return n2 != 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkResultSet();
        return this.m_totalRowCount != 0 && this.getRow() == this.m_totalRowCount + 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.traceInfo("isLast: ");
        if (this.isAfterLast()) {
            return true;
        }
        boolean bl = this.next();
        this.setRow(this.getRow() - 1);
        return !bl;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.traceInfo("beforeFirst: ");
        this.setQueryMode();
        this.checkResultSet();
        this.checkScrollable();
        if (this.getRow() != 0) {
            if (this.m_rowsetIndex != 0) {
                this.setRowset(0);
            }
            this.setRow(0);
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.traceInfo("first: ");
        this.setQueryMode();
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean previous() throws SQLException {
        this.traceInfo("previous: ");
        this.setQueryMode();
        this.checkResultSet();
        this.checkScrollable();
        if (this.getRow() <= 1) {
            if (this.getRow() == 1) {
                this.setRow(0);
            }
            return false;
        }
        this.setRow(this.getRow() - 1);
        if (this.getRow() < this.m_fetchStartRow) {
            this.setRowset(this.m_rowsetIndex - 1);
        }
        return true;
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.traceInfo("absolute: ");
        if (n < 0) {
            this.last();
            n = this.m_totalRowCount + n;
        } else {
            this.setQueryMode();
            this.checkResultSet();
            this.checkScrollable();
            if (this.getRow() == 0 && !this.next()) {
                return false;
            }
        }
        while (n < this.m_fetchStartRow) {
            this.setRowset(this.m_rowsetIndex - 1);
        }
        while (n >= this.m_fetchStartRow + this.m_fetchRowCount) {
            this.setRowset(this.m_rowsetIndex + 1);
            if (this.m_totalRowCount == 0 || n <= this.m_totalRowCount) continue;
            this.setRow(this.m_totalRowCount + 1);
            return false;
        }
        this.setRow(n);
        return true;
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.traceInfo("relative: ");
        this.setQueryMode();
        this.checkResultSet();
        this.checkScrollable();
        if (this.getRow() == 0) {
            return false;
        }
        int n2 = this.getRow() + n;
        return n2 <= 0 ? false : this.absolute(n2);
    }

    @Override
    public boolean last() throws SQLException {
        this.traceInfo("last: ");
        this.setQueryMode();
        this.checkResultSet();
        this.checkScrollable();
        if (this.getRow() == 0 && !this.next()) {
            return false;
        }
        while (this.m_totalRowCount == 0) {
            this.setRowset(this.m_rowsetIndex + 1);
        }
        return this.absolute(this.m_totalRowCount);
    }

    @Override
    public void afterLast() throws SQLException {
        this.traceInfo("afterLast: ");
        if (this.last()) {
            this.next();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkResultSet();
        this.checkUpdatable();
        if (this.isInsertMode()) {
            throw OdxCLJException.error(25540);
        }
        if (this.executeUpdate("delete from " + this.getColumnTable(1) + this.assembleWhere()) == 0) {
            throw OdxCLJException.error(25541);
        }
    }

    @Override
    public void updateColumnValue(int n, String string) throws SQLException {
        this.checkResultSet();
        this.checkUpdatable();
        this.checkColumnNumber(n);
        if (this.isQueryMode()) {
            this.checkRow();
            if (this.m_updateBuffer == null) {
                this.m_updateBuffer = new String[this.getColumnCount() + 1];
                this.m_updateFlags = new boolean[this.getColumnCount() + 1];
            }
            for (int i = 1; i < this.m_updateBuffer.length; ++i) {
                this.m_updateBuffer[i] = this.getColumnValueString(i);
                this.m_updateFlags[i] = false;
            }
            this.setUpdateMode();
        }
        if (this.m_updateBuffer == null) {
            throw OdxCLJException.error(25537);
        }
        this.m_updateBuffer[n] = string;
        this.m_updateFlags[n] = true;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.setQueryMode();
    }

    @Override
    public void updateRow() throws SQLException {
        int n;
        if (!this.isUpdateMode()) {
            throw OdxCLJException.error(25539);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("update ");
        stringBuffer.append(this.getColumnTable(1));
        stringBuffer.append(" set ");
        boolean bl = true;
        for (n = 1; n < this.m_updateBuffer.length; ++n) {
            if (!this.m_updateFlags[n]) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append("\"");
            stringBuffer.append(this.getColumnName(n));
            stringBuffer.append("\"");
            stringBuffer.append("=");
            stringBuffer.append(this.m_updateBuffer[n] == null ? "' '" : OdxCLJDataResultSet.fixString(this.m_updateBuffer[n]));
        }
        if (bl) {
            throw OdxCLJException.error(25539);
        }
        stringBuffer.append(this.assembleWhere());
        if (this.executeUpdate(stringBuffer.toString()) == 0) {
            throw OdxCLJException.error(25542);
        }
        n = this.getRow() - this.m_fetchStartRow + 1;
        block9: for (int i = 1; i < this.m_updateBuffer.length; ++i) {
            if (!this.m_updateFlags[i]) continue;
            switch (this.getColumnDatatype(i)) {
                case 1: {
                    OdxCLJNative.updateColumnValueString(this.m_fetchBuffer, this.m_oaResult, n, i, this.m_rowSize, OdxCLJNative.getBytes(this.m_updateBuffer[i]));
                    continue block9;
                }
                case -7: {
                    OdxCLJNative.updateColumnValueBoolean(this.m_fetchBuffer, this.m_oaResult, n, i, this.m_rowSize, this.m_updateBuffer[i] == null ? false : Boolean.valueOf(this.m_updateBuffer[i]));
                    continue block9;
                }
                case -5: {
                    OdxCLJNative.updateColumnValueBigInt(this.m_fetchBuffer, this.m_oaResult, n, i, this.m_rowSize, this.m_updateBuffer[i] == null ? 0L : Long.valueOf(this.m_updateBuffer[i]), this.m_endian);
                    continue block9;
                }
                case -6: 
                case 4: 
                case 5: {
                    OdxCLJNative.updateColumnValueInt(this.m_fetchBuffer, this.m_oaResult, n, i, this.m_rowSize, this.m_updateBuffer[i] == null ? 0 : Integer.valueOf(this.m_updateBuffer[i]), this.m_endian);
                    continue block9;
                }
                case 6: 
                case 7: {
                    OdxCLJNative.updateColumnValueDouble(this.m_fetchBuffer, this.m_oaResult, n, i, this.m_rowSize, this.m_updateBuffer[i] == null ? 0.0 : Double.valueOf(this.m_updateBuffer[i]), this.m_endian);
                    continue block9;
                }
                case 91: 
                case 92: 
                case 93: {
                    int[] nArray = null;
                    if (this.m_updateBuffer[i] != null) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(new java.sql.Date(Long.valueOf(this.m_updateBuffer[i])));
                        nArray = new int[]{calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13), calendar.get(14)};
                    }
                    OdxCLJNative.updateColumnValueTimestamp(this.m_fetchBuffer, this.m_oaResult, n, i, this.m_rowSize, nArray, this.m_endian);
                }
            }
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.setInsertMode();
        if (this.m_updateBuffer == null) {
            this.m_updateBuffer = new String[this.getColumnCount() + 1];
            this.m_updateFlags = new boolean[this.getColumnCount() + 1];
        } else {
            for (int i = 1; i < this.m_updateBuffer.length; ++i) {
                this.m_updateBuffer[i] = null;
                this.m_updateFlags[i] = false;
            }
        }
    }

    @Override
    public void insertRow() throws SQLException {
        int n;
        if (!this.isInsertMode()) {
            throw OdxCLJException.error(25538);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into ");
        stringBuffer.append(this.getColumnTable(1));
        stringBuffer.append(" (");
        boolean bl = true;
        for (n = 1; n < this.m_updateBuffer.length; ++n) {
            if (!this.m_updateFlags[n]) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append("\"");
            stringBuffer.append(this.getColumnName(n));
            stringBuffer.append("\"");
        }
        if (bl) {
            throw OdxCLJException.error(25538);
        }
        stringBuffer.append(") values (");
        bl = true;
        for (n = 1; n < this.m_updateBuffer.length; ++n) {
            if (!this.m_updateFlags[n]) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.m_updateBuffer[n] == null ? "' '" : OdxCLJDataResultSet.fixString(this.m_updateBuffer[n]));
        }
        stringBuffer.append(")");
        this.executeUpdate(stringBuffer.toString());
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.setQueryMode();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.m_oaResult != null) {
            this.m_oaResult = null;
            this.m_fetchBuffer = null;
            this.m_nullIndBuffer = null;
        }
        if (this.m_rowset != null) {
            this.m_rowset.clear();
            this.m_rowset = null;
        }
        this.m_updateBuffer = null;
        this.m_status = null;
        this.m_statement = null;
    }

    private class OdxCLJRowset {
        private byte[] m_fetchBuffer;
        private byte[] m_nullIndBuffer;
        private int m_fetchStartRow;
        private int m_fetchRowCount;

        private OdxCLJRowset(byte[] byArray, byte[] byArray2, int n, int n2) {
            this.m_fetchBuffer = byArray;
            this.m_nullIndBuffer = byArray2;
            this.m_fetchStartRow = n;
            this.m_fetchRowCount = n2;
        }
    }
}

