/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import omnidex.client.OdxCLJConnection;
import omnidex.client.OdxCLJException;
import omnidex.jdbc.OdxJDBCConnection;
import omnidex.jdbc.OdxJDBCStatement;

public final class OdxJDBCPreparedStatement
extends OdxJDBCStatement
implements PreparedStatement {
    private String[] m_values;
    private ArrayList<String> m_sqls;
    private char m_sqlEscape = '\u0000';

    protected OdxJDBCPreparedStatement(OdxJDBCConnection odxJDBCConnection) {
        super(odxJDBCConnection);
    }

    protected void initialize(OdxCLJConnection odxCLJConnection, String string, int n, int n2, boolean bl) throws SQLException {
        this.initialize(odxCLJConnection, n, n2, bl);
        this.m_sqlEscape = odxCLJConnection.parseSqlEscapeOption(string);
        this.m_sqls = new ArrayList();
        while (true) {
            int n3;
            if ((n3 = string.indexOf("?")) < 0) break;
            if (n3 == 0) {
                this.m_sqls.add("");
            } else {
                this.m_sqls.add(string.substring(0, n3));
            }
            if (n3 < string.length() - 1) {
                string = string.substring(n3 + 1);
                continue;
            }
            string = "";
        }
        this.m_sqls.add(string);
        this.m_values = new String[this.m_sqls.size() - 1];
    }

    private String combineSQL() throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.m_values.length; ++n) {
            if (this.m_values[n] == null) {
                throw OdxCLJException.error(25518);
            }
            stringBuffer.append(this.m_sqls.get(n));
            stringBuffer.append(this.m_values[n]);
        }
        stringBuffer.append(this.m_sqls.get(n));
        return stringBuffer.toString();
    }

    private void checkSQL() throws SQLException {
        if (this.m_sqls == null) {
            throw OdxCLJException.error(25513);
        }
    }

    private void checkIndex(int n) throws SQLException {
        this.checkSQL();
        if (n <= 0 || n > this.m_values.length) {
            throw OdxCLJException.error(25519);
        }
    }

    private String prepValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        if (string.indexOf("'") != -1 || this.m_sqlEscape != '\u0000' && string.indexOf(this.m_sqlEscape) != -1) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length + 64];
            int n = 0;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] == '\'') {
                    cArray2[n++] = cArray[n2];
                } else if (this.m_sqlEscape != '\u0000' && cArray[n2] == this.m_sqlEscape) {
                    cArray2[n++] = this.m_sqlEscape;
                }
                if (n >= cArray2.length) {
                    char[] cArray3 = new char[cArray2.length + 64];
                    System.arraycopy(cArray2, 0, cArray3, 0, cArray2.length);
                    cArray2 = cArray3;
                }
                cArray2[n++] = cArray[n2++];
            }
            stringBuffer.append(cArray2, 0, n);
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkSQL();
        return super.executeQuery(this.combineSQL());
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkSQL();
        return super.executeUpdate(this.combineSQL());
    }

    public String getNativeSQL() throws SQLException {
        this.checkSQL();
        return this.combineSQL();
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = "NULL";
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = bl ? "1" : "0";
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = String.valueOf(by);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = String.valueOf(s);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = String.valueOf(n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = String.valueOf(l);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = String.valueOf(f);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = String.valueOf(d);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = bigDecimal.toString();
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = this.prepValue(string);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkIndex(n);
        this.setString(n, Base64.getEncoder().encodeToString(byArray));
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = this.prepValue(date.toString());
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = this.prepValue(time.toString());
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = this.prepValue(timestamp.toString());
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIndex(n);
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
            this.m_values[n - 1] = new String(byArray, "8859_1");
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIndex(n);
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
            this.m_values[n - 1] = new String(byArray, "UTF8");
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkIndex(n);
        byte[] byArray = new byte[n2];
        try {
            inputStream.read(byArray, 0, n2);
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
        this.setBytes(n, byArray);
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.m_values.length; ++i) {
            this.m_values[i] = null;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        switch (n2) {
            case -7: {
                this.setBoolean(n, Boolean.valueOf(object.toString()));
                break;
            }
            case -6: {
                this.setByte(n, Byte.parseByte(object.toString()));
                break;
            }
            case 5: {
                this.setShort(n, Short.parseShort(object.toString()));
                break;
            }
            case 4: {
                this.setInt(n, Integer.parseInt(object.toString()));
                break;
            }
            case -5: {
                this.setLong(n, Long.parseLong(object.toString()));
                break;
            }
            case 6: 
            case 7: {
                this.setFloat(n, Float.parseFloat(object.toString()));
                break;
            }
            case 8: {
                this.setDouble(n, Double.parseDouble(object.toString()));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = new BigDecimal(object.toString());
                bigDecimal.setScale(n3);
                this.setBigDecimal(n, bigDecimal);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                this.setString(n, object.toString());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (object instanceof Blob) {
                    this.setBlob(n, (Blob)object);
                    break;
                }
                if (object instanceof byte[]) {
                    this.setBytes(n, (byte[])object);
                    break;
                }
                if (object instanceof Serializable) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.flush();
                        this.setBytes(n, byteArrayOutputStream.toByteArray());
                        break;
                    }
                    catch (IOException iOException) {
                        throw OdxCLJException.error(iOException);
                    }
                }
                throw OdxCLJException.error(25523);
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2005: 
            case 2006: {
                throw OdxCLJException.error(25524);
            }
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.checkIndex(n);
        if (object.getClass().isPrimitive()) {
            this.setString(n, object.toString());
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof StringBuffer) {
            this.setString(n, object.toString());
        } else {
            this.setObject(n, object, -2);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkSQL();
        return super.execute(this.combineSQL());
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch(this.combineSQL());
        this.clearParameters();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkIndex(n);
        char[] cArray = new char[n2];
        try {
            reader.read(cArray, 0, n2);
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
        this.m_values[n - 1] = this.prepValue(new String(cArray));
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.checkIndex(n);
        long l = blob.length();
        if (l > Integer.MAX_VALUE) {
            throw OdxCLJException.error(25520);
        }
        this.setBinaryStream(n, blob.getBinaryStream(), (int)l);
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = array.toString();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.m_resultSet == null) {
            this.executeQuery();
        }
        return this.m_resultSet.getMetaData();
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setDate(n, date);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setTime(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(n, timestamp);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.checkIndex(n);
        this.m_values[n - 1] = "NULL";
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

