/*
 * Decompiled with CFR 0.152.
 */
package omnidex.jdbc;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Calendar;
import java.util.Map;
import omnidex.client.OdxCLJException;
import omnidex.client.OdxCLJResultSet;
import omnidex.client.OdxCLJTrace;
import omnidex.jdbc.OdxJDBCBlob;
import omnidex.jdbc.OdxJDBCResultSetMetaData;
import omnidex.jdbc.OdxJDBCStatement;

public final class OdxJDBCResultSet
implements ResultSet {
    private OdxCLJResultSet m_oaResultSet;
    private OdxJDBCResultSetMetaData m_metaData;
    private Statement m_jdbcStatement;
    private InputStream m_inputStream;

    protected OdxJDBCResultSet(Statement statement, OdxCLJResultSet odxCLJResultSet) {
        this.trace(null);
        this.m_oaResultSet = odxCLJResultSet;
        this.m_metaData = new OdxJDBCResultSetMetaData(odxCLJResultSet);
        this.m_jdbcStatement = statement;
        this.m_inputStream = null;
    }

    protected void checkResultSet() throws SQLException {
        if (this.m_oaResultSet == null) {
            throw OdxCLJException.error(25501);
        }
        if (this.m_inputStream != null) {
            try {
                this.m_inputStream.close();
            }
            catch (IOException iOException) {
                throw OdxCLJException.error(iOException);
            }
            this.m_inputStream = null;
        }
    }

    private void trace(String string) {
        OdxCLJTrace.print(this, string);
    }

    protected void dump() {
        OdxCLJTrace.print("Inside " + this);
        OdxCLJTrace.print(" - " + this.m_oaResultSet);
        OdxCLJTrace.print(" - " + this.m_jdbcStatement);
        if (this.m_metaData != null) {
            OdxCLJTrace.print(" - " + this.m_metaData);
            this.m_metaData.dump();
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.trace("next");
        this.checkResultSet();
        return this.m_oaResultSet.next();
    }

    @Override
    public void close() throws SQLException {
        this.trace("close");
        if (this.m_oaResultSet != null) {
            this.m_oaResultSet.close();
            this.m_oaResultSet = null;
            this.m_jdbcStatement = null;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.wasNull();
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        this.trace("getString(" + string + ")");
        return string;
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkResultSet();
        boolean bl = this.m_oaResultSet.getColumnValueBoolean(n);
        this.trace("getBoolean " + bl);
        return bl;
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkResultSet();
        byte by = this.m_oaResultSet.getColumnValueByte(n);
        this.trace("getByte " + by);
        return by;
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkResultSet();
        short s = this.m_oaResultSet.getColumnValueShort(n);
        this.trace("getShort " + s);
        return s;
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkResultSet();
        int n2 = this.m_oaResultSet.getColumnValueInt(n);
        this.trace("getInt " + n2);
        return n2;
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkResultSet();
        long l = this.m_oaResultSet.getColumnValueLong(n);
        this.trace("getLong " + l);
        return l;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkResultSet();
        float f = this.m_oaResultSet.getColumnValueFloat(n);
        this.trace("getFloat " + f);
        return f;
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkResultSet();
        double d = this.m_oaResultSet.getColumnValueDouble(n);
        this.trace("getDouble " + d);
        return d;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        if (string == null) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        bigDecimal.setScale(n2);
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        return string == null ? null : Base64.getDecoder().decode(string);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        this.checkResultSet();
        Date date = this.m_oaResultSet.getColumnValueDate(n);
        this.trace("getDate " + date);
        return date;
    }

    @Override
    public Time getTime(int n) throws SQLException {
        this.checkResultSet();
        Time time = this.m_oaResultSet.getColumnValueTime(n);
        this.trace("getTime " + time);
        return time;
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkResultSet();
        Timestamp timestamp = this.m_oaResultSet.getColumnValueTimestamp(n);
        this.trace("getTimestamp " + timestamp);
        return timestamp;
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        if (string == null) {
            return null;
        }
        try {
            this.m_inputStream = new ByteArrayInputStream(string.getBytes("8859_1"));
            return this.m_inputStream;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw OdxCLJException.error(unsupportedEncodingException);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        if (string == null) {
            return null;
        }
        try {
            this.m_inputStream = new ByteArrayInputStream(string.getBytes("8859_1"));
            return this.m_inputStream;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw OdxCLJException.error(unsupportedEncodingException);
        }
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : new ByteArrayInputStream(byArray);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return ((OdxJDBCStatement)this.m_jdbcStatement).getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkResultSet();
        return new OdxJDBCResultSetMetaData(this.m_oaResultSet);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        this.checkResultSet();
        Object object = this.m_oaResultSet.getColumnValueObject(n);
        this.trace("getObject " + object);
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getColumnNumber(string);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        return new CharArrayReader(this.getString(n).toCharArray());
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkResultSet();
        String string = this.m_oaResultSet.getColumnValueString(n);
        return string == null ? null : new BigDecimal(string);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getRow();
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.absolute(n);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.relative(n);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.previous();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.setFetchDirection(n);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getFetchDirection();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.setFetchSize(n);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkResultSet();
        return this.m_oaResultSet.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, null);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(bl));
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(by));
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(s));
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(n2));
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(l));
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(f));
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, String.valueOf(d));
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, bigDecimal.toString());
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, string);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, Base64.getEncoder().encodeToString(byArray));
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, date.toString());
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, time.toString());
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, timestamp.toString());
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkResultSet();
        try {
            byte[] byArray = new byte[n2];
            inputStream.read(byArray, 0, n2);
            this.m_oaResultSet.updateColumnValue(n, new String(byArray, "8859_1"));
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkResultSet();
        try {
            byte[] byArray = new byte[n2];
            inputStream.read(byArray, 0, n2);
            this.updateBytes(n, byArray);
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkResultSet();
        try {
            char[] cArray = new char[n2];
            reader.read(cArray, 0, n2);
            this.m_oaResultSet.updateColumnValue(n, new String(cArray));
        }
        catch (IOException iOException) {
            throw OdxCLJException.error(iOException);
        }
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, object.toString());
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateColumnValue(n, object.toString());
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkResultSet();
        this.m_oaResultSet.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkResultSet();
        return this.m_jdbcStatement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        return new OdxJDBCBlob(this.getBytes(n));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw OdxCLJException.error(25500);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_oaResultSet != null;
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

