#!/bin/sh
#********************************************************************
#*         odxset.sh - Set up the library and class path
#*    (C) COPYRIGHT DYNAMIC INFORMATION SYSTEMS CORPORATION
#*              -----   ALL RIGHTS RESERVED  -----
#*    The use, duplication, or distribution of this software without
#*    the express written consent of Dynamic Information Systems Corp.
#*    is prohibited.
#********************************************************************
#
set -e
#
# set the LD_LIBRARY_PATH
#
if [ -z "$LD_LIBRARY_PATH" ]; then
  export LD_LIBRARY_PATH="/opt/omnidex/lib"
elif [ "$LD_LIBRARY_PATH" != "/opt/omnidex/lib" ]; then
  p="/opt/omnidex/lib"
  case $LD_LIBRARY_PATH in
      "$p":*) LD_LIBRARY_PATH=${LD_LIBRARY_PATH#$p:} ;;
      *:"$p") LD_LIBRARY_PATH=${LD_LIBRARY_PATH%:$p} ;;
      *:"$p":*) LD_LIBRARY_PATH=${LD_LIBRARY_PATH%":$p"*}${LD_LIBRARY_PATH##*"$p"} ;;
  esac
  export LD_LIBRARY_PATH=$p":"$LD_LIBRARY_PATH
fi  
#
echo LD_LIBRARY_PATH is set to $LD_LIBRARY_PATH
#
# set the CLASSPATH
#
if [ -z "$CLASSPATH" ]; then
  export CLASSPATH="/opt/omnidex/lib/Omnidex.jar"
elif [ "$CLASSPATH" != "/opt/omnidex/lib/Omnidex.jar" ]; then
  p="/opt/omnidex/lib/Omnidex.jar"
  case $CLASSPATH in
      "$p":*) CLASSPATH=${CLASSPATH#$p:} ;;
      *:"$p") CLASSPATH=${CLASSPATH%:$p} ;;
      *:"$p":*) CLASSPATH=${CLASSPATH%":$p"*}${CLASSPATH##*"$p"} ;;
  esac
  export CLASSPATH=$p":"$CLASSPATH
fi
#
echo CLASSPATH is set to $CLASSPATH
#

