create environment    
 in                   "simple.xml"
 with                 delete;


create database       "SIMPLE"
  type                FILE
  index_directory     "idx"
 in                   "simple.xml";


create table          "COUNTRIES"
 options              "DELIMITED COLUMN=',' RECORD='\r\n' QUOTES"
 physical             "dat\countries.csv"
 (
  "COUNTRY"           CHARACTER(2)      omnidex,
  "DESCRIPTION"       STRING(47)        quicktext,
  "LATITUDE"          FLOAT             omnidex      usage "LATITUDE",
  "LONGITUDE"         FLOAT             omnidex      usage "LONGITUDE",
  "CAPITAL"           STRING(31)        quicktext,
  "CAPITAL_LAT"       FLOAT             omnidex      usage "LATITUDE",
  "CAPITAL_LONG"      FLOAT             omnidex      usage "LONGITUDE",
  constraint COUNTRIES_COUNTRY_PK primary ("COUNTRY")
 )
 in                   "simple.xml";


create table          "STATES"
 options              "DELIMITED COLUMN='\t' RECORD='\r\n' QUOTES"
 physical             "dat\states.txt"
 (
  "STATE"             CHARACTER(2)      omnidex,
  "DESCRIPTION"       STRING(31)        quicktext,
  "STATE_CODE"        CHARACTER(2)      omnidex,
  "REGION"            CHARACTER(2)      omnidex,
  "COUNTRY"           CHARACTER(2)      omnidex,
  "TAX_RATE"          FLOAT             omnidex,
  constraint STATES_STATE_PK primary ("STATE"),
  constraint STATES_COUNTRY_FK foreign ("COUNTRY") references "COUNTRIES"
 )
 in                   "simple.xml";


create table          "GENDERS"
 options              "DELIMITED COLUMN='|' RECORD='\r\n' QUOTES"
 physical             "dat\genders.txt"
 (
  "GENDER"            CHARACTER(1)      omnidex,
  "DESCRIPTION"       STRING(31)        quicktext,
  constraint GENDERS_GENDER_PK primary ("GENDER")
 )
 in                   "simple.xml";


create table          "HOUSEHOLDS"
 options              "DELIMITED COLUMN='##' RECORD='\n' QUOTES"
 physical             "dat\households.txt"
 (
  "HOUSEHOLD"         CHARACTER(12)     omnidex,
  "ADDRESS"           CHARACTER(50)     quicktext,
  "CITY"              CHARACTER(28)     quicktext,
  "STATE"             CHARACTER(2)      omnidex,
  "ZIP"               CHARACTER(5)      omnidex,
  "COUNTRY"           CHARACTER(2)      omnidex,
  constraint HOUSEHOLDS_HOUSEHOLD_PK primary ("HOUSEHOLD"),
  constraint HOUSEHOLDS_STATE_FK foreign ("STATE") references "STATES",
  constraint HOUSEHOLDS_COUNTRY_FK foreign ("COUNTRY") references "COUNTRIES"
 )
 in                   "simple.xml";


create table          "INDIVIDUALS"
 options              "DELIMITED COLUMN='%%' RECORD='~~' QUOTES"
 physical             "dat\individuals.txt"
 (
  "INDIVIDUAL"        CHARACTER(12)     omnidex,
  "HOUSEHOLD"         CHARACTER(12)     omnidex,
  "NAME"              CHARACTER(50)     quicktext,
  "GENDER"            CHARACTER(1)      omnidex bitmap,
  "BIRTHDATE"         ANSI DATE         omnidex,
  "PHONE"             CHARACTER(14)     omnidex,
  "EMAIL"             CHARACTER(60)     quicktext,
  constraint INDIVIDUALS_INDIVIDUAL_PK primary ("INDIVIDUAL"),
  constraint INDIVIDUALS_HOUSEHOLD_FK foreign ("HOUSEHOLD") references "HOUSEHOLDS",
  constraint INDIVIDUALS_GENDER_FK foreign ("GENDER") references "GENDERS",
 )
 in                   "simple.xml";
